/*:
 * @target MZ
 * @plugindesc SE・BGS・BGMの音量をプラグインコマンドで設定するプラグイン
 * @help
 * 【使い方】
 * プラグインコマンドを使用して、各種音量を設定できます。
 * 
 * 【プラグインコマンド】
 * - SetBGMVolume volume
 * - SetBGSVolume volume
 * - SetSEVolume volume
 * 
 * volumeには0～100の数値を指定してください。
 *
 * 例:
 * SetBGMVolume 50   → BGMの音量を50に設定
 * SetBGSVolume 30   → BGSの音量を30に設定
 * SetSEVolume 70    → SEの音量を70に設定
 *
 * 【更新履歴】
 * 1.0.0 - 初版リリース
 * 
 * @command SetBGMVolume
 * @text BGMの音量設定
 * @desc BGMの音量を設定します（0～100）
 * @arg volume
 * @type number
 * @min 0
 * @max 100
 * @default 100
 * 
 * @command SetBGSVolume
 * @text BGSの音量設定
 * @desc BGSの音量を設定します（0～100）
 * @arg volume
 * @type number
 * @min 0
 * @max 100
 * @default 100
 * 
 * @command SetSEVolume
 * @text SEの音量設定
 * @desc SEの音量を設定します（0～100）
 * @arg volume
 * @type number
 * @min 0
 * @max 100
 * @default 100
 */

(() => {
    const pluginName = "AudioVolumeControl";

    PluginManager.registerCommand(pluginName, "SetBGMVolume", args => {
        const volume = Math.max(0, Math.min(100, Number(args.volume) || 0));
        $dataSystem.volumeBgm = volume;
        AudioManager.bgmVolume = volume;
    });

    PluginManager.registerCommand(pluginName, "SetBGSVolume", args => {
        const volume = Math.max(0, Math.min(100, Number(args.volume) || 0));
        $dataSystem.volumeBgs = volume;
        AudioManager.bgsVolume = volume;
    });

    PluginManager.registerCommand(pluginName, "SetSEVolume", args => {
        const volume = Math.max(0, Math.min(100, Number(args.volume) || 0));
        $dataSystem.volumeSe = volume;
        AudioManager.seVolume = volume;
    });
})();
